#include <arduino.h>
#include <EEPROM.h>
#include "zg_balancer.h"
#include "zg_capacity.h"

extern char gPrintBuf[50];
void handleInterlock(const stSensorData *pstControlSensorData, const stZgSettings *pstZgSettings)
{
  //if interlock is enabled
  if (pstZgSettings->interlockWeight > 0)
  {
    //weight is less than handler weight by a 1 kg margin
    if(pstControlSensorData->rawAdcCounts < (pstZgSettings->interlockWeight - (int)(ONE_KG_WEIGHT * 1)))
    {
        digitalWrite(LED3, HIGH);  //indicate we are good/safe to declamp

        if (digitalRead(DI_DISENGAGE_CLAMPING) == LOW && digitalRead(DI_ENGAGE_CLAMPING) == HIGH)
        {
          //declamp
          digitalWrite(LED1, LOW);   //S1=false
          digitalWrite(LED2, HIGH);  //S2=true
        }

        if (digitalRead(DI_ENGAGE_CLAMPING) == LOW && digitalRead(DI_DISENGAGE_CLAMPING) == HIGH)
        {
          //clamp
          digitalWrite(LED1, HIGH);  //S1=true
          digitalWrite(LED2, LOW);   //S2=false
        }
    }
	  else
	  {
      digitalWrite(LED3, LOW);  //indicate we are not good to declamp          
	  }
  }
}
