#include <arduino.h>
#include <EEPROM.h>
#include "zg_balancer.h"
#include "zg_capacity.h"

extern char gPrintBuf[50];

uint8_t runFloatMode(stSensorData *pstControlSensorData, const stZgSettings *pStZgSettings)
{
  static uint8_t floatModeState = FLOAT_MODE_STATE_IDLE;
  static unsigned long timerStartValue = 0;
  uint8_t weightRange;
  static uint8_t ledToggle = 1;

  switch (floatModeState)
  {
    case FLOAT_MODE_STATE_IDLE:
      if (TREND_STATE_INCREASED == pstControlSensorData->trend)
      {
        floatModeState = FLOAT_MODE_STATE_DOWN;
      }
      else if (TREND_STATE_DECREASED == pstControlSensorData->trend)
      {
        floatModeState = FLOAT_MODE_STATE_UP;
      }
      else
      {
        floatModeState = FLOAT_MODE_STATE_IDLE;
      }

      break;

    case FLOAT_MODE_STATE_UP:
      //user is trying to pull the load up. So, balancer has to lift the weight
      //sometimes we are entring into this state when tmpReadingChange is zero
      //hence this check

      if (TREND_STATE_DECREASED == pstControlSensorData->trend)
      {
        weightRange = getCurrentWeightRange(pstControlSensorData->rawAdcCounts);
        airIntake(pStZgSettings->liftSpeed, weightRange);
        //sprintf(gPrintBuf, "weight change...%d", pstControlSensorData->delta);
        //Serial.println(gPrintBuf);

        floatModeState = FLOAT_MODE_STATE_UP_IN_PROGRESS;
      }
      else
      {
        floatModeState = FLOAT_MODE_STATE_IDLE;
      }
      break;

    case FLOAT_MODE_STATE_UP_IN_PROGRESS:
      if (TREND_STATE_DECREASED == pstControlSensorData->trend)
      {
        // //check for min weight or no load balancing
        // if (pstControlSensorData->rawAdcCounts < pStZgSettings->noLoadBalancingWeight)
        // {
        //   floatModeState = FLOAT_MODE_STATE_HIT_MIN_WEIGHT;
        //   stopAirFlow();
        //   timerStartValue = millis();
        // }
      }
      else
      {
        stopAirFlow();
        floatModeState = FLOAT_MODE_STATE_IDLE;
      }
      if (pstControlSensorData->delta < -(int)(ONE_KG_WEIGHT * 10))
      {
        stopAirFlow();
        timerStartValue = millis();
        floatModeState = FLOAT_MODE_STATE_HIT_RAPID_WEIGHT_CHANGE;
      }
      break;

    case FLOAT_MODE_STATE_DOWN:
      //user is trying to pull the load down. So, balancer has to lower the weight
      //sometimes we are entring into this state when tmpReadingChange is zero
      //hence this check
      if (TREND_STATE_INCREASED == pstControlSensorData->trend)
      {

        weightRange = getCurrentWeightRange(pstControlSensorData->rawAdcCounts);
        airExhaust(pStZgSettings->lowerSpeed, weightRange);

        //sprintf(gPrintBuf, "FLOAT_MODE_DOWN weight change %d", tmpReadingChange);
        //Serial.println(gPrintBuf);
        floatModeState = FLOAT_MODE_STATE_DOWN_IN_PROGRESS;
      }
      else
      {
        floatModeState = FLOAT_MODE_STATE_IDLE;
      }
      break;

    case FLOAT_MODE_STATE_DOWN_IN_PROGRESS:
      //while we are in float mode down, continue
      if (TREND_STATE_INCREASED == pstControlSensorData->trend)
      {
      }
      else
      {
        //stopPressureDecrease();
        stopAirFlow();
        floatModeState = FLOAT_MODE_STATE_IDLE;
      }
      if (pstControlSensorData->delta > (int)(ONE_KG_WEIGHT * 10))
      {
        stopAirFlow();
        timerStartValue = millis();
        floatModeState = FLOAT_MODE_STATE_HIT_RAPID_WEIGHT_CHANGE;
      }

      break;
    case FLOAT_MODE_STATE_HIT_RAPID_WEIGHT_CHANGE:
      //blink RED LED
      if ((millis() - timerStartValue) > 250)
      {
        timerStartValue = millis();
        digitalWrite(LED_ERROR, ledToggle);
        ledToggle = ledToggle ^ 1;
      }
      //user has to use handle mode to restore pressure/resting value
      if (TREND_STATE_RESTING == pstControlSensorData->trend)
      {
        floatModeState = FLOAT_MODE_STATE_IDLE;
        digitalWrite(LED_ERROR, 0);
      }
    // case FLOAT_MODE_STATE_HIT_MIN_WEIGHT:
    //   //blink RED LED
    //   if ((millis() - timerStartValue) > 250)
    //   {
    //     timerStartValue = millis();
    //     digitalWrite(LED_ERROR, ledToggle);
    //     ledToggle = ledToggle ^ 1;
    //   }
    //   //user has to use handle mode to restore pressure/resting value
    //   if (pstControlSensorData->rawAdcCounts > pStZgSettings->noLoadBalancingWeight)
    //   {
    //     floatModeState = FLOAT_MODE_STATE_IDLE;
    //     stopAirFlow();
    //     timerStartValue = millis();
    //   }
    
    // break;
    default:
      Serial.println("Hit default case in run float mode");
      break;
  }
  return floatModeState;
}