#include <arduino.h>
#include <EEPROM.h>
#include "zg_balancer.h"
#include "zg_capacity.h"

extern char gPrintBuf[50];
void handleCycleCount(const stSensorData *pstControlSensorData, stZgData *pstZgData, stZgSettings *pStZgSettings)
{
  static uint8_t loadState = CYCLE_COUNT_STATE_INIT;
  static unsigned long timerStartCount = 0;
  static uint8_t saveData = 0;
    
  uint16_t airLiftedTargetWeight = pStZgSettings->noLoadBalancingWeight + TEN_KG_WEIGHT;
  uint16_t groundedTargetWeight  = pStZgSettings->noLoadBalancingWeight + ONE_KG_WEIGHT;
  
  switch (loadState)
  {
    case CYCLE_COUNT_STATE_INIT:
      if (pstControlSensorData->rawAdcCounts > airLiftedTargetWeight)
      {
        loadState = CYCLE_COUNT_STATE_AIR_LIFTED;
        timerStartCount = millis();  //use this timer to save data every 5 mins
      }
      else if (pstControlSensorData->rawAdcCounts < groundedTargetWeight)
      {
        loadState = CYCLE_COUNT_STATE_GROUNDED;
        timerStartCount = millis();
      }
      else
      {
      }
      break;

    case CYCLE_COUNT_STATE_AIR_LIFTED:
      if (pstControlSensorData->rawAdcCounts < groundedTargetWeight)
      {
        pstZgData->cycleCount++;
        loadState = CYCLE_COUNT_STATE_GROUNDED;
        saveData = 1;
      }

      break;
    case CYCLE_COUNT_STATE_GROUNDED:
      if (pstControlSensorData->rawAdcCounts > airLiftedTargetWeight)
      {
        loadState = CYCLE_COUNT_STATE_AIR_LIFTED;
      }

      break;
    default:
      Serial.print("Hit default in handle cycle state");
      break;
  }

  if (((millis() - timerStartCount) > SETTINGS_SAVE_TIME_INTERVAL))
  {
    if (1 == saveData)
    {
      WriteToEeprom(EEPROM_ADDR_ZG_DATA_START, (uint8_t *)pstZgData, sizeof(stZgData));
      saveData = 0;
    }
    timerStartCount = millis();  //reset timer
    //Serial.println("\nTime to save");
  }
}