#include "zg_balancer.h"
#include "zg_capacity.h"
#include <arduino.h>

#if ZG_CAPACITY == 500
  extern stWtRangeVsSpeedLookUp gstWtVsSpeedLow[MAX_SPEED_RANGES];
  extern stWtRangeVsSpeedLookUp gstWtVsSpeedMed[MAX_SPEED_RANGES];
  extern stWtRangeVsSpeedLookUp gstWtVsSpeedHi[MAX_SPEED_RANGES];

  uint8_t getCurrentWeightRange(uint16_t controlSensorAdcCounts)
  {
    //Divided balancer capacity of 226 kg into 7 parts because
    //we have 7 possible intake combinations. This is considered as

    if (controlSensorAdcCounts < (int)(ONE_KG_WEIGHT * 33))  
  {  
    return 0;
  }
  else if (controlSensorAdcCounts < (int)(ONE_KG_WEIGHT * 66))  
  {
    return 1;
  }
  else if (controlSensorAdcCounts < (int)(ONE_KG_WEIGHT * 99))  
  {
    return 2;
  }
  else if (controlSensorAdcCounts < (int)(ONE_KG_WEIGHT * 132))  
  {
    return 3;
  }
  else if (controlSensorAdcCounts < (int)(ONE_KG_WEIGHT * 165))  
  {
    return 4;
  }
  else if (controlSensorAdcCounts < (int)(ONE_KG_WEIGHT * 198))  
  {
    return 5;
  }
  else if (controlSensorAdcCounts < (int)(ONE_KG_WEIGHT * 231))  
  {
    return 6;
  }
  else
  {
    Serial.println("\nInvalid weight assessment");
    return 0;
  }
}

  void createWeightVsSpeedLookUpTable()
  {
    //these tables are created manually by using the data obtained in lab testing

    //weight range 0 to 33 kg lifting
    gstWtVsSpeedHi[0].mValveLiftingCombination = 1;
    gstWtVsSpeedHi[0].dValveLiftingCombination = 0;
    gstWtVsSpeedMed[0].mValveLiftingCombination = 1;
    gstWtVsSpeedMed[0].dValveLiftingCombination = 1;
    gstWtVsSpeedLow[0].mValveLiftingCombination = 2;
    gstWtVsSpeedLow[0].dValveLiftingCombination = 5;

    //weight range 0 to 33 kg lowering
    gstWtVsSpeedHi[0].mValveLoweringCombination = 0;
    gstWtVsSpeedHi[0].dValveLoweringCombination = 5;
    gstWtVsSpeedMed[0].mValveLoweringCombination = 0;
    gstWtVsSpeedMed[0].dValveLoweringCombination = 4;
    gstWtVsSpeedLow[0].mValveLoweringCombination = 0;
    gstWtVsSpeedLow[0].dValveLoweringCombination = 3;

    //weight range > 33 to 66 kg lifting
    gstWtVsSpeedHi[1].mValveLiftingCombination = 3;
    gstWtVsSpeedHi[1].dValveLiftingCombination = 1;
    gstWtVsSpeedMed[1].mValveLiftingCombination = 3;
    gstWtVsSpeedMed[1].dValveLiftingCombination = 2;
    gstWtVsSpeedLow[1].mValveLiftingCombination = 3;
    gstWtVsSpeedLow[1].dValveLiftingCombination = 3;
    //weight range > 33 kg to 66 kg lowering
    gstWtVsSpeedHi[1].mValveLoweringCombination = 0;
    gstWtVsSpeedHi[1].dValveLoweringCombination = 4;
    gstWtVsSpeedMed[1].mValveLoweringCombination = 0;
    gstWtVsSpeedMed[1].dValveLoweringCombination = 3;
    gstWtVsSpeedLow[1].mValveLoweringCombination = 0;
    gstWtVsSpeedLow[1].dValveLoweringCombination = 2;

    //weight range > 66 to 99 kg lifting
    gstWtVsSpeedHi[2].mValveLiftingCombination = 3;
    gstWtVsSpeedHi[2].dValveLiftingCombination = 0;
    gstWtVsSpeedMed[2].mValveLiftingCombination = 2;
    gstWtVsSpeedMed[2].dValveLiftingCombination = 0;
    gstWtVsSpeedLow[2].mValveLiftingCombination = 4;
    gstWtVsSpeedLow[2].dValveLiftingCombination = 3;
    //weight range > 66 kg to 99 kg lowering
    gstWtVsSpeedHi[2].mValveLoweringCombination = 0;
    gstWtVsSpeedHi[2].dValveLoweringCombination = 4;
    gstWtVsSpeedMed[2].mValveLoweringCombination = 0;
    gstWtVsSpeedMed[2].dValveLoweringCombination = 3;
    gstWtVsSpeedLow[2].mValveLoweringCombination = 0;
    gstWtVsSpeedLow[2].dValveLoweringCombination = 2;

    //weight range > 99 to 132 kg lifting
    gstWtVsSpeedHi[3].mValveLiftingCombination = 3;
    gstWtVsSpeedHi[3].dValveLiftingCombination = 0;
    gstWtVsSpeedMed[3].mValveLiftingCombination = 2;
    gstWtVsSpeedMed[3].dValveLiftingCombination = 0;
    gstWtVsSpeedLow[3].mValveLiftingCombination = 6;
    gstWtVsSpeedLow[3].dValveLiftingCombination = 2;
    //weight range > 99 kg to 132 kg lowering
    gstWtVsSpeedHi[3].mValveLoweringCombination = 0;
    gstWtVsSpeedHi[3].dValveLoweringCombination = 4;
    gstWtVsSpeedMed[3].mValveLoweringCombination = 0;
    gstWtVsSpeedMed[3].dValveLoweringCombination = 3;
    gstWtVsSpeedLow[3].mValveLoweringCombination = 0;
    gstWtVsSpeedLow[3].dValveLoweringCombination = 2;

    //weight range > 132 to 165 kg lifting
    gstWtVsSpeedHi[4].mValveLiftingCombination = 3;
    gstWtVsSpeedHi[4].dValveLiftingCombination = 0;
    gstWtVsSpeedMed[4].mValveLiftingCombination = 5;
    gstWtVsSpeedMed[4].dValveLiftingCombination = 1;
    gstWtVsSpeedLow[4].mValveLiftingCombination = 3;
    gstWtVsSpeedLow[4].dValveLiftingCombination = 0;
    //weight range > 132 kg to 165 kg lowering
    gstWtVsSpeedHi[4].mValveLoweringCombination = 0;
    gstWtVsSpeedHi[4].dValveLoweringCombination = 3;
    gstWtVsSpeedMed[4].mValveLoweringCombination = 0;
    gstWtVsSpeedMed[4].dValveLoweringCombination = 2;
    gstWtVsSpeedLow[4].mValveLoweringCombination = 0;
    gstWtVsSpeedLow[4].dValveLoweringCombination = 1;

    //weight range > 165 to 198 kg lifting
    gstWtVsSpeedHi[5].mValveLiftingCombination = 4;
    gstWtVsSpeedHi[5].dValveLiftingCombination = 0;
    gstWtVsSpeedMed[5].mValveLiftingCombination = 3;
    gstWtVsSpeedMed[5].dValveLiftingCombination = 0;
    gstWtVsSpeedLow[5].mValveLiftingCombination = 5;
    gstWtVsSpeedLow[5].dValveLiftingCombination = 0;
    //weight range > 165 kg to 198 kg lowering
    gstWtVsSpeedHi[5].mValveLoweringCombination = 0;
    gstWtVsSpeedHi[5].dValveLoweringCombination = 3;
    gstWtVsSpeedMed[5].mValveLoweringCombination = 0;
    gstWtVsSpeedMed[5].dValveLoweringCombination = 2;
    gstWtVsSpeedLow[5].mValveLoweringCombination = 0;
    gstWtVsSpeedLow[5].dValveLoweringCombination = 1;

    //weight range > 198 to 231 kg lifting
    gstWtVsSpeedHi[6].mValveLiftingCombination = 7;
    gstWtVsSpeedHi[6].dValveLiftingCombination = 0;
    gstWtVsSpeedMed[6].mValveLiftingCombination = 5;
    gstWtVsSpeedMed[6].dValveLiftingCombination = 0;
    gstWtVsSpeedLow[6].mValveLiftingCombination = 3;
    gstWtVsSpeedLow[6].dValveLiftingCombination = 0;
    //weight range > 198 kg to 231 kg lowering
    gstWtVsSpeedHi[6].mValveLoweringCombination = 0;
    gstWtVsSpeedHi[6].dValveLoweringCombination = 2;
    gstWtVsSpeedMed[6].mValveLoweringCombination = 0;
    gstWtVsSpeedMed[6].dValveLoweringCombination = 1;
    gstWtVsSpeedLow[6].mValveLoweringCombination = 0;
    gstWtVsSpeedLow[6].dValveLoweringCombination = 1;
  }
#endif
