#include "zg_balancer.h"
#include "zg_capacity.h"
#include <arduino.h>

#if ZG_CAPACITY == 350
  extern stWtRangeVsSpeedLookUp gstWtVsSpeedLow[MAX_SPEED_RANGES];
  extern stWtRangeVsSpeedLookUp gstWtVsSpeedMed[MAX_SPEED_RANGES];
  extern stWtRangeVsSpeedLookUp gstWtVsSpeedHi[MAX_SPEED_RANGES];

uint8_t getCurrentWeightRange(uint16_t controlSensorAdcCounts)
{
  //Divided balancer capacity of 160 kg into 5 parts
  //so that we define inlet and outlet valve combinations 
  //for thos 4 ranges only
  
  if (controlSensorAdcCounts < (int)(ONE_KG_WEIGHT * 30))  
  {  
    return 0;
  }
  else if (controlSensorAdcCounts < (int)(ONE_KG_WEIGHT * 60))  
  {
    return 1;
  }
  else if (controlSensorAdcCounts < (int)(ONE_KG_WEIGHT * 90))  
  {
    return 2;
  }
  else if (controlSensorAdcCounts < (int)(ONE_KG_WEIGHT * 120))  
  {
    return 3;
  }
  else if (controlSensorAdcCounts < (int)(ONE_KG_WEIGHT * 160))  
  {
    return 4;
  }
  else
  {
    Serial.println("\nInvalid weight assessment");
    return 0;
  }
}

void createWeightVsSpeedLookUpTable()
{
  //these tables are created manually by using the data obtained in lab testing

  //weight range 0 to 30 kg lifting
  gstWtVsSpeedHi[0].mValveLiftingCombination = 1;
  gstWtVsSpeedHi[0].dValveLiftingCombination = 0;
  gstWtVsSpeedMed[0].mValveLiftingCombination = 1;
  gstWtVsSpeedMed[0].dValveLiftingCombination = 0;
  gstWtVsSpeedLow[0].mValveLiftingCombination = 1;
  gstWtVsSpeedLow[0].dValveLiftingCombination = 1;

  //weight range 0 to 30 kg lowering
  gstWtVsSpeedHi[0].mValveLoweringCombination = 0;
  gstWtVsSpeedHi[0].dValveLoweringCombination = 1;
  gstWtVsSpeedMed[0].mValveLoweringCombination = 0;
  gstWtVsSpeedMed[0].dValveLoweringCombination = 1;
  gstWtVsSpeedLow[0].mValveLoweringCombination = 0;
  gstWtVsSpeedLow[0].dValveLoweringCombination = 1;

  //weight range > 30 to 60 kg lifting
  gstWtVsSpeedHi[1].mValveLiftingCombination = 2;
  gstWtVsSpeedHi[1].dValveLiftingCombination = 0;
  gstWtVsSpeedMed[1].mValveLiftingCombination = 1;
  gstWtVsSpeedMed[1].dValveLiftingCombination = 0;
  gstWtVsSpeedLow[1].mValveLiftingCombination = 1;
  gstWtVsSpeedLow[1].dValveLiftingCombination = 0;
  
  //weight range > 30 kg to 60 kg lowering
  gstWtVsSpeedHi[1].mValveLoweringCombination = 0;
  gstWtVsSpeedHi[1].dValveLoweringCombination = 2;
  gstWtVsSpeedMed[1].mValveLoweringCombination = 0;
  gstWtVsSpeedMed[1].dValveLoweringCombination = 2;
  gstWtVsSpeedLow[1].mValveLoweringCombination = 0;
  gstWtVsSpeedLow[1].dValveLoweringCombination = 1;

  //weight range > 60 to 90 kg lifting
  gstWtVsSpeedHi[2].mValveLiftingCombination = 3;
  gstWtVsSpeedHi[2].dValveLiftingCombination = 0;
  gstWtVsSpeedMed[2].mValveLiftingCombination = 3;
  gstWtVsSpeedMed[2].dValveLiftingCombination = 1;
  gstWtVsSpeedLow[2].mValveLiftingCombination = 1;
  gstWtVsSpeedLow[2].dValveLiftingCombination = 0;
  //weight range > 60 kg to 90 kg lowering
  gstWtVsSpeedHi[2].mValveLoweringCombination = 0;
  gstWtVsSpeedHi[2].dValveLoweringCombination = 3;
  gstWtVsSpeedMed[2].mValveLoweringCombination = 0;
  gstWtVsSpeedMed[2].dValveLoweringCombination = 2;
  gstWtVsSpeedLow[2].mValveLoweringCombination = 0;
  gstWtVsSpeedLow[2].dValveLoweringCombination = 1;

   //weight range > 90 kg to 120 kg lifting
  gstWtVsSpeedHi[3].mValveLiftingCombination = 7;
  gstWtVsSpeedHi[3].dValveLiftingCombination = 0;
  gstWtVsSpeedMed[3].mValveLiftingCombination = 5;
  gstWtVsSpeedMed[3].dValveLiftingCombination = 0;
  gstWtVsSpeedLow[3].mValveLiftingCombination = 3;
  gstWtVsSpeedLow[3].dValveLiftingCombination = 0;
  //weight range > 90 kg to 120 kg lowering
  gstWtVsSpeedHi[3].mValveLoweringCombination = 0;
  gstWtVsSpeedHi[3].dValveLoweringCombination = 3;
  gstWtVsSpeedMed[3].mValveLoweringCombination = 0;
  gstWtVsSpeedMed[3].dValveLoweringCombination = 2;
  gstWtVsSpeedLow[3].mValveLoweringCombination = 0;
  gstWtVsSpeedLow[3].dValveLoweringCombination = 1;

    //weight range > 120 kg to 160 kg lifting
  gstWtVsSpeedHi[4].mValveLiftingCombination = 7;
  gstWtVsSpeedHi[4].dValveLiftingCombination = 0;
  gstWtVsSpeedMed[4].mValveLiftingCombination = 6;
  gstWtVsSpeedMed[4].dValveLiftingCombination = 0;
  gstWtVsSpeedLow[4].mValveLiftingCombination = 4;
  gstWtVsSpeedLow[4].dValveLiftingCombination = 0;
  //weight range > 120 kg to 160 kg lowering
  gstWtVsSpeedHi[4].mValveLoweringCombination = 0;
  gstWtVsSpeedHi[4].dValveLoweringCombination = 3;
  gstWtVsSpeedMed[4].mValveLoweringCombination = 0;
  gstWtVsSpeedMed[4].dValveLoweringCombination = 2;
  gstWtVsSpeedLow[4].mValveLoweringCombination = 0;
  gstWtVsSpeedLow[4].dValveLoweringCombination = 1;

}

#endif
