#include "zg_balancer.h"
#include "zg_capacity.h"
#include <arduino.h>

#if ZG_CAPACITY == 150
  extern stWtRangeVsSpeedLookUp gstWtVsSpeedLow[MAX_SPEED_RANGES];
  extern stWtRangeVsSpeedLookUp gstWtVsSpeedMed[MAX_SPEED_RANGES];
  extern stWtRangeVsSpeedLookUp gstWtVsSpeedHi[MAX_SPEED_RANGES];

uint8_t getCurrentWeightRange(uint16_t controlSensorAdcCounts)
{
  //Divided balancer capacity of 68 kg into 4 parts
  //so that we define inlet and outlet valve combinations 
  //for thos 4 ranges only
  
  if (controlSensorAdcCounts < (int)(ONE_KG_WEIGHT * 15))  
  {  
    return 0;
  }
  else if (controlSensorAdcCounts < (int)(ONE_KG_WEIGHT * 30))  
  {
    return 1;
  }
  else if (controlSensorAdcCounts < (int)(ONE_KG_WEIGHT * 45))  
  {
    return 2;
  }
  else if (controlSensorAdcCounts < (int)(ONE_KG_WEIGHT * 70))  
  {
    return 3;
  }
  else
  {
    Serial.println("\nInvalid weight assessment");
    return 0;
  }
}

void createWeightVsSpeedLookUpTable()
{
  //these tables are created manually by using the data obtained in lab testing

  //weight range 0 to 15 kg lifting
  gstWtVsSpeedHi[0].mValveLiftingCombination = 3;
  gstWtVsSpeedHi[0].dValveLiftingCombination = 4;
  gstWtVsSpeedMed[0].mValveLiftingCombination = 2;
  gstWtVsSpeedMed[0].dValveLiftingCombination = 0;
  gstWtVsSpeedLow[0].mValveLiftingCombination = 1;
  gstWtVsSpeedLow[0].dValveLiftingCombination = 0;

  //weight range 0 to 15 kg lowering
  gstWtVsSpeedHi[0].mValveLoweringCombination = 0;
  gstWtVsSpeedHi[0].dValveLoweringCombination = 4;
  gstWtVsSpeedMed[0].mValveLoweringCombination = 0;
  gstWtVsSpeedMed[0].dValveLoweringCombination = 3;
  gstWtVsSpeedLow[0].mValveLoweringCombination = 0;
  gstWtVsSpeedLow[0].dValveLoweringCombination = 2;

  //weight range > 15 to 30 kg lifting
  gstWtVsSpeedHi[1].mValveLiftingCombination = 4;
  gstWtVsSpeedHi[1].dValveLiftingCombination = 0;
  gstWtVsSpeedMed[1].mValveLiftingCombination = 3;
  gstWtVsSpeedMed[1].dValveLiftingCombination = 2;
  gstWtVsSpeedLow[1].mValveLiftingCombination = 3;
  gstWtVsSpeedLow[1].dValveLiftingCombination = 3;
  
  //weight range > 15 kg to 30 kg lowering
  gstWtVsSpeedHi[1].mValveLoweringCombination = 0;
  gstWtVsSpeedHi[1].dValveLoweringCombination = 4;
  gstWtVsSpeedMed[1].mValveLoweringCombination = 0;
  gstWtVsSpeedMed[1].dValveLoweringCombination = 2;
  gstWtVsSpeedLow[1].mValveLoweringCombination = 0;
  gstWtVsSpeedLow[1].dValveLoweringCombination = 1;

  //weight range > 30 to 45 kg lifting
  gstWtVsSpeedHi[2].mValveLiftingCombination = 6;
  gstWtVsSpeedHi[2].dValveLiftingCombination = 0;
  gstWtVsSpeedMed[2].mValveLiftingCombination = 5;
  gstWtVsSpeedMed[2].dValveLiftingCombination = 0;
  gstWtVsSpeedLow[2].mValveLiftingCombination = 4;
  gstWtVsSpeedLow[2].dValveLiftingCombination = 0;
  //weight range > 30 kg to 45 kg lowering
  gstWtVsSpeedHi[2].mValveLoweringCombination = 0;
  gstWtVsSpeedHi[2].dValveLoweringCombination = 3;
  gstWtVsSpeedMed[2].mValveLoweringCombination = 0;
  gstWtVsSpeedMed[2].dValveLoweringCombination = 2;
  gstWtVsSpeedLow[2].mValveLoweringCombination = 0;
  gstWtVsSpeedLow[2].dValveLoweringCombination = 1;

  //weight range > 45 lifting (balancer not able to lift in this range )
  gstWtVsSpeedHi[3].mValveLiftingCombination = 7;
  gstWtVsSpeedHi[3].dValveLiftingCombination = 0;
  gstWtVsSpeedMed[3].mValveLiftingCombination = 6;
  gstWtVsSpeedMed[3].dValveLiftingCombination = 0;
  gstWtVsSpeedLow[3].mValveLiftingCombination = 4;
  gstWtVsSpeedLow[3].dValveLiftingCombination = 0;
  //weight range > 45 lowering
  gstWtVsSpeedHi[3].mValveLoweringCombination = 0;
  gstWtVsSpeedHi[3].dValveLoweringCombination = 2;
  gstWtVsSpeedMed[3].mValveLoweringCombination = 0;
  gstWtVsSpeedMed[3].dValveLoweringCombination = 2;
  gstWtVsSpeedLow[3].mValveLoweringCombination = 0;
  gstWtVsSpeedLow[3].dValveLoweringCombination = 1;

}

#endif
